--***********************************************************
--**                    ShadowCop		                   **
--***********************************************************

require "TimedActions/ISBaseTimedAction"
ISChainsawRevolutionMenu = {};

ISChainsawRevolutionMenu.clearFetch = function()
	ObjTree = nil
	InvItem = nil
	PetrolCan = nil	
end

ISChainsawRevolutionMenu.doInvMenu = function(_player, context, worldobjects, test)
	ISChainsawRevolutionMenu.clearFetch();
	
	local playerObj = getSpecificPlayer(_player);
	
	for i,k in pairs(worldobjects) do
	-- inventory item list
		if instanceof(k, "InventoryItem") then
			ISChainsawRevolutionMenu.checkInvItem(playerObj, context, worldobjects, k);			
		elseif not instanceof(k, "InventoryItem") and #k.items > 1 then
            ISChainsawRevolutionMenu.checkInvItem(playerObj, context, worldobjects, k.items[1]);
		end
	end
end

ISChainsawRevolutionMenu.checkInvItem = function(player, context, worldobjects, InvItem)

	PetrolCan = player:getInventory():FindAndReturn("PetrolCan");
	if InvItem:getType() == "Chainsaw" then
		local ModData = InvItem:getModData();
		-- ModData Init
		if(ModData.FuelAmt == nil) then
			ModData.FuelAmt = 0;
		end
		if(ModData.Run == nil) then
			ModData.Run = false;
		end		
		--Chainsaw Fuel
		if (PetrolCan ~= nil and ModData.Run == false and ModData.FuelAmt < 120) then
			if test == true then return true; end
			local fuelOption = context:addOption(getText("ContextMenu_ChainsawFuel"), worldobjects, nil);
			local fuelSubMenu = ISContextMenu:getNew(context);
			context:addSubMenu(fuelOption, fuelSubMenu);
			fuelSubMenu:addOption(getText("ContextMenu_ChainsawFuelOnce"), worldobjects, ISChainsawRevolutionMenu.onFuel, player, InvItem, PetrolCan, false);
			fuelSubMenu:addOption(getText("ContextMenu_ChainsawFuelFull"), worldobjects, ISChainsawRevolutionMenu.onFuel, player, InvItem, PetrolCan, true);
		end
		--Chainsaw Start
		if ModData.Run == false and ModData.FuelAmt > 0 then
			if test == true then return true; end
			context:addOption(getText("ContextMenu_StartChainsaw"), worldobjects, ISChainsawRevolutionMenu.onStart, player, InvItem);
		end
		--Chainsaw Stop
		if ModData.Run == true then
			if test == true then return true; end
			context:addOption(getText("ContextMenu_StopChainsaw"), worldobjects, ISChainsawRevolutionMenu.onStopp, player, InvItem);
		end
		--Chainsaw Info Window
		context:addOption(getText("ContextMenu_InfoChainsaw"), worldobjects, ISChainsawRevolutionMenu.onDisplayChainsawInfo, player, InvItem)
	end
end

ISChainsawRevolutionMenu.doWorldMenu = function(_player, context, worldobjects, test)
	ISChainsawRevolutionMenu.clearFetch();
	local playerObj = getSpecificPlayer(_player);	
	for i,k in pairs(worldobjects) do
		if instanceof(k, "IsoTree") and ObjTree == nil then
			ObjTree = k;
			-- Chainsaw equipped?
			local handItem = playerObj:getPrimaryHandItem();
			if handItem and handItem:getType() == "Chainsaw" then
				local ModData = handItem:getModData();
				if ModData.FuelAmt > 0 then				
					context:addOption(getText("ContextMenu_Chop_Tree_Chainsaw"), worldobjects, ISChainsawRevolutionMenu.onChopTreeChainsaw, playerObj, ObjTree, handItem);
				end
			else
			--Chainsaw in inventory?
				local playerInv = playerObj:getInventory():getItems();
				for n = 0, playerInv:size()-1 do
					local item = playerInv:get(n);
					if item:getType() == "Chainsaw" then
						local ModData = item:getModData();
						if ModData.FuelAmt > 0 then
							context:addOption(getText("ContextMenu_Chop_Tree_Chainsaw"), worldobjects, ISChainsawRevolutionMenu.onChopTreeChainsaw, playerObj, ObjTree, item);
							break
						end
					end
				end
			end
		end
	end
end

function ISChainsawRevolutionMenu.onDisplayChainsawInfo(worldobjects, player, chainsaw)
	ISTimedActionQueue.add(ISInfoChainsawAction:new(player, chainsaw));
end

ISChainsawRevolutionMenu.onStart = function(worldobjects, player, chainsaw)	
	if chainsaw == nil then return end
	if not player:isEquipped(chainsaw) then
		if not chainsaw:getContainer():isInCharacterInventory(player) then
			ISTimedActionQueue.add(ISInventoryTransferAction:new(player, chainsaw, chainsaw:getContainer(), player:getInventory()));
		end
		ISTimedActionQueue.add(ISEquipWeaponAction:new(player, chainsaw, 50, true, true));
	end
	ISTimedActionQueue.add(ISInfoChainsawAction:new(player, chainsaw));
	ISTimedActionQueue.add(ISStartChainsawAction:new(player, chainsaw, 60));	
end

ISChainsawRevolutionMenu.onStopp = function(worldobjects, player, chainsaw)	
	if chainsaw == nil then return end
	if not player:isEquipped(chainsaw) then
		if not chainsaw:getContainer():isInCharacterInventory(player) then
			ISTimedActionQueue.add(ISInventoryTransferAction:new(player, chainsaw, chainsaw:getContainer(), player:getInventory()));
		end
		ISTimedActionQueue.add(ISEquipWeaponAction:new(player, chainsaw, 50, true, true));		
	end
	ISTimedActionQueue.add(ISStopChainsawAction:new(player, chainsaw, 0));
end

ISChainsawRevolutionMenu.onFuel = function(worldobjects, player, chainsaw, petrolcan, full)
	if chainsaw == nil or petrolcan == nil then return end
	if not player:isEquipped(chainsaw) then
		if not chainsaw:getContainer():isInCharacterInventory(player) then
			ISTimedActionQueue.add(ISInventoryTransferAction:new(player, chainsaw, chainsaw:getContainer(), player:getInventory()));
		end
		ISTimedActionQueue.add(ISEquipWeaponAction:new(player, chainsaw, 50, true, true));
	end
	ISTimedActionQueue.add(ISFuelChainsawAction:new(player, chainsaw, petrolcan, full, 50));
end

ISChainsawRevolutionMenu.onChopTreeChainsaw = function(worldobjects, player, ObjTree, chainsaw)
	if ObjTree:getObjectIndex() == -1 then return end
	if luautils.walkAdj(player, ObjTree:getSquare()) then
		if chainsaw == nil then return end
		ModData = chainsaw:getModData();
		if not player:isEquipped(chainsaw) or not ModData.Run == true then
			ISChainsawRevolutionMenu.onStart(worldobjects, player, chainsaw);
		end 				
		ISTimedActionQueue.add(ISChopTreeChainsawAction:new(player, ObjTree))
	end
end

Events.OnFillWorldObjectContextMenu.Add(ISChainsawRevolutionMenu.doWorldMenu);
Events.OnFillInventoryObjectContextMenu.Add(ISChainsawRevolutionMenu.doInvMenu);